/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.PowerSystem;
import forestry.api.core.INBTTagable;
import net.minecraft.nbt.NBTTagCompound;

public class PowerInfo
implements INBTTagable {
    private float currentEnergy;
    private float maxEnergy;

    public PowerInfo(IPoweredMachine machine, float currentInput) {
        this.currentEnergy = (float)machine.getInterface().getEnergy(PowerSystem.RF);
        this.maxEnergy = (float)machine.getInterface().getCapacity(PowerSystem.RF);
    }

    public PowerInfo() {
        this.currentEnergy = 0.0f;
        this.maxEnergy = 0.0f;
    }

    public int getStoredEnergy() {
        return (int)this.currentEnergy;
    }

    public int getMaxEnergy() {
        return (int)this.maxEnergy;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.currentEnergy = nbttagcompound.func_74762_e("current");
        this.maxEnergy = nbttagcompound.func_74762_e("max");
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("current", this.getStoredEnergy());
        nbttagcompound.func_74768_a("max", this.getMaxEnergy());
    }
}

